/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.List;
import net.adventurez.entity.VoidShadowEntity;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.entity.nonliving.VoidBulletEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class VoidFragmentEntity
extends FlyingMob
implements Enemy {
    public static final EntityDataAccessor<Boolean> IS_VOID_ORB = SynchedEntityData.m_135353_(VoidFragmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean isVoidOrb;
    private int deathTick;

    public VoidFragmentEntity(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createVoidFragmentAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 10.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        if (spawnReason == MobSpawnType.SPAWN_EGG) {
            this.setVoidOrb(true);
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_VOID_ORB, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsVoidOrb", this.isVoidOrb);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.isVoidOrb = tag.m_128471_("IsVoidOrb");
        this.setVoidOrb(this.isVoidOrb);
    }

    public void setVoidOrb(boolean orb) {
        this.isVoidOrb = orb;
        this.f_19804_.m_135381_(IS_VOID_ORB, (Object)orb);
        this.m_20090_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20390_(1.0f, this.isVoidOrb || (Boolean)this.f_19804_.m_135370_(IS_VOID_ORB) != false ? 2.1f : 1.2f);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (IS_VOID_ORB.equals(data)) {
            this.m_20090_();
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
        }
        super.m_7350_(data);
    }

    public void m_6153_() {
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 10; ++i) {
                double d = this.f_19796_.m_188583_() * 0.05;
                double e = this.f_19796_.m_188583_() * 0.05;
                double f = this.f_19796_.m_188583_() * 0.05;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d, e, f);
            }
        }
        ++this.deathTick;
        if (this.deathTick >= 20 && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().m_5776_() && this.isVoidOrb) {
            AABB box = new AABB(this.m_20183_());
            List list = this.m_9236_().m_6443_(VoidShadowEntity.class, box.m_82400_(120.0), EntitySelector.f_20408_);
            for (int i = 0; i < list.size(); ++i) {
                ((VoidShadowEntity)((Object)list.get(i))).m_6469_(this.m_269291_().m_269425_(), 40.0f);
            }
        }
        super.m_6667_(source);
    }

    public void m_8024_() {
        super.m_8024_();
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_45946_(TargetingConditions.m_148352_().m_26883_(0.8), (LivingEntity)this) != null) {
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.isVoidOrb ? 4.0f : 3.0f, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_7500_()) {
            return super.m_6469_(source, amount);
        }
        if (this.m_6673_(source) || source.m_7640_() instanceof ThrownRockEntity || this.isVoidOrb && !(source.m_7640_() instanceof VoidBulletEntity)) {
            return false;
        }
        return super.m_6469_(source, source.m_7640_() instanceof VoidBulletEntity ? this.m_21223_() : amount);
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_147207_(MobEffectInstance effect, Entity entity) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }
}

